% tvs: TeleVision image of matrix, scaled (e.g. to see matrix as picture)
%
% scales and displays a greyscale image;   Steve Mann, 1990; revised 2000
%
% Examples:
% tvs(Z)
% tvs(X,Y,Z) % axes are labelled accordingly
%            % plot is also scaled accordingly
%
% THIS VERSION DOES NOT display NaN as red, or even handle NaN!!!
% but this version is not written in C and therefore not arch. dependent!!!

function like_PVwave_tvscl(A,in_y,in_z) % returns nothing

if nargin==2
  disp('tvs: you entered 2 arguments; not sure how to handle that case yet')
  error('tvs: exiting')
end%if

if nargin==3
  X=A;
  Y=in_y;
  A=in_z;
end%if

map = colormap;
[M,N]=size(map);
if N~=3
  disp('tvs: colormap is not 3 wide;')
  disp('     i am exiting so you can do something about it')
  return
end%if

if M>256
  disp(sprintf('tvs: colormap length=%g: longer than 256; ',M));
  disp('     exiting...')
  return
end%if

% check to see if colormap last element is red
% cannot check is not red: ~=[1 0 0] must be cyan=[0 1 1]
%%%last_isred = 0; % initialize to false
%%%if map(M,:)==[1 0 0] % get the check down to a scalar
%%%  last_isred = 1; % true
%%%end%if
%%%if ~last_isred
%%%  disp1='tvs: last colormap entry not red (for NaN): ';
%%%  disp2='setting map to gray+1extra red';
%%%  disp([disp1 disp2])
%%%  greynan(M)
%%%end%if

% scale non-NaN parts on 1..M
Amin = min(min(A));
Amax = max(max(A));

if Amin==Amax
  disp1='tvs: all the non-NaN values are the same; ';
  disp2='you will get a division by 0 err';
  disp([disp1 disp2])
end%if

%%%if ~last_isred
%%%  Asc = (M-1)*(A-Amin)/(Amax-Amin) + 1;  % on 1..M      (M+1 is red)
%%%  B = chnan(Asc,M+1);  % last entry in new extended colormap (red)
%%%else %if
%%%  Asc = (M-2)*(A-Amin)/(Amax-Amin) + 1;  % on 1..M-1    (M is red)
%%%  B = chnan(Asc,M);    % last entry of existing colormap (red)
%%%end%if
%B = chnan(Asc,0);  % first entry in colormap (red)
B = (M-1)*(A-Amin)/(Amax-Amin)+1;  % on 1..M-1    (M is red)

if nargin==1
  image(B)      % just z
end%if
if nargin==3
  image(X,Y,B)  % x,y,z
end%if

%axis('equal')
axis('image')   % equal axes with cropping as well.

set(gcf,'pointer','crosshair')

colormap('gray')

